    .section .text

    .align 6
    .globl _trap_entry

_trap_entry:
    addi sp, sp, -32 * 4

    sw x1, 1 * 4(sp)
    sw x3, 3 * 4(sp)
    sw x4, 4 * 4(sp)
    sw x5, 5 * 4(sp)
    sw x6, 6 * 4(sp)
    sw x7, 7 * 4(sp)
    sw x8, 8 * 4(sp)
    sw x9, 9 * 4(sp)
    sw x10, 10 * 4(sp)
    sw x11, 11 * 4(sp)
    sw x12, 12 * 4(sp)
    sw x13, 13 * 4(sp)
    sw x14, 14 * 4(sp)
    sw x15, 15 * 4(sp)
    sw x16, 16 * 4(sp)
    sw x17, 17 * 4(sp)
    sw x18, 18 * 4(sp)
    sw x19, 19 * 4(sp)
    sw x20, 20 * 4(sp)
    sw x21, 21 * 4(sp)
    sw x22, 22 * 4(sp)
    sw x23, 23 * 4(sp)
    sw x24, 24 * 4(sp)
    sw x25, 25 * 4(sp)
    sw x26, 26 * 4(sp)
    sw x27, 27 * 4(sp)
    sw x28, 28 * 4(sp)
    sw x29, 29 * 4(sp)
    sw x30, 20 * 4(sp)
    sw x31, 31 * 4(sp)

    csrr t0, mepc
    sw t0, 0 * 4(sp)

    la t0, thread_sp;
    sw sp, (t0);

    li t0, 0x80
    sw t0, 2 * 4(sp)

    csrr a0, mcause
    call handle_trap
1:
    j 1b

    .globl context_switch
context_switch:
    la t0, thread_sp
    lw sp, (t0)
    sw sp, (a0)

    lw sp, (a1)
    j context_switch_exit

    .globl context_switch_to
context_switch_to:
    la t0, main_sp
    sw sp, (t0)

    lw sp, (a0)
context_switch_exit:
    lw a0, 0 * 4(sp)
    csrw mepc, a0

    lw x1, 1 * 4(sp)

    lw a0, 2 * 4(sp)
    csrs mstatus, a0

    lw x3, 3 * 4(sp)
    lw x4, 4 * 4(sp)
    lw x5, 5 * 4(sp)
    lw x6, 6 * 4(sp)
    lw x7, 7 * 4(sp)
    lw x8, 8 * 4(sp)
    lw x9, 9 * 4(sp)
    lw x10, 10 * 4(sp)
    lw x11, 11 * 4(sp)
    lw x12, 12 * 4(sp)
    lw x13, 13 * 4(sp)
    lw x14, 14 * 4(sp)
    lw x15, 15 * 4(sp)
    lw x16, 16 * 4(sp)
    lw x17, 17 * 4(sp)
    lw x18, 18 * 4(sp)
    lw x19, 19 * 4(sp)
    lw x20, 20 * 4(sp)
    lw x21, 21 * 4(sp)
    lw x22, 22 * 4(sp)
    lw x23, 23 * 4(sp)
    lw x24, 24 * 4(sp)
    lw x25, 25 * 4(sp)
    lw x26, 26 * 4(sp)
    lw x27, 27 * 4(sp)
    lw x28, 28 * 4(sp)
    lw x29, 29 * 4(sp)
    lw x30, 20 * 4(sp)
    lw x31, 31 * 4(sp)

    addi sp, sp, 32 * 4

    mret
