#define MSTATUS_MIE     0x00000008

.macro DISABLE_MIE
    csrc mstatus, MSTATUS_MIE
.endm

.macro SAVE_CONTEXT
    addi sp, sp, -33 * 4
    sw x1, 0 * 4(sp)
    sw x2, 1 * 4(sp)
    sw x3, 2 * 4(sp)
    sw x4, 3 * 4(sp)
    sw x5, 4 * 4(sp)
    sw x6, 5 * 4(sp)
    sw x7, 6 * 4(sp)
    sw x8, 7 * 4(sp)
    sw x9, 8 * 4(sp)
    sw x10, 9 * 4(sp)
    sw x11, 10 * 4(sp)
    sw x12, 11 * 4(sp)
    sw x13, 12 * 4(sp)
    sw x14, 13 * 4(sp)
    sw x15, 14 * 4(sp)
    sw x16, 15 * 4(sp)
    sw x17, 16 * 4(sp)
    sw x18, 17 * 4(sp)
    sw x19, 18 * 4(sp)
    sw x20, 19 * 4(sp)
    sw x21, 20 * 4(sp)
    sw x22, 21 * 4(sp)
    sw x23, 22 * 4(sp)
    sw x24, 23 * 4(sp)
    sw x25, 24 * 4(sp)
    sw x26, 25 * 4(sp)
    sw x27, 26 * 4(sp)
    sw x28, 27 * 4(sp)
    sw x29, 28 * 4(sp)
    sw x30, 29 * 4(sp)
    sw x31, 30 * 4(sp)
    csrr t0, mepc
    sw t0, 31 * 4(sp)
    csrr t0, mstatus 
    sw t0, 32 * 4(sp)
.endm

.macro RESTORE_CONTEXT
    lw t0, 31 * 4(sp)
    csrw mepc, t0
    lw t0, 32 * 4(sp)
    csrw mstatus, t0
    lw x1, 0 * 4(sp)
    lw x2, 1 * 4(sp)
    lw x3, 2 * 4(sp)
    lw x4, 3 * 4(sp)
    lw x5, 4 * 4(sp)
    lw x6, 5 * 4(sp)
    lw x7, 6 * 4(sp)
    lw x8, 7 * 4(sp)
    lw x9, 8 * 4(sp)
    lw x10, 9 * 4(sp)
    lw x11, 10 * 4(sp)
    lw x12, 11 * 4(sp)
    lw x13, 12 * 4(sp)
    lw x14, 13 * 4(sp)
    lw x15, 14 * 4(sp)
    lw x16, 15 * 4(sp)
    lw x17, 16 * 4(sp)
    lw x18, 17 * 4(sp)
    lw x19, 18 * 4(sp)
    lw x20, 19 * 4(sp)
    lw x21, 20 * 4(sp)
    lw x22, 21 * 4(sp)
    lw x23, 22 * 4(sp)
    lw x24, 23 * 4(sp)
    lw x25, 24 * 4(sp)
    lw x26, 25 * 4(sp)
    lw x27, 26 * 4(sp)
    lw x28, 27 * 4(sp)
    lw x29, 28 * 4(sp)
    lw x30, 29 * 4(sp)
    lw x31, 30 * 4(sp)
    addi sp, sp, 33 * 4
.endm

    .section .text

    .align 14
    .globl _vector_base

_vector_base:
    j _defaut_handler
    .align 2
    .word 0
    .word 0
    .word 0
    .word 0
    .word 0
    .word 0
    .word _timer_handler_entry
    .word 0
    .word 0

_defaut_handler:
    j _defaut_handler
    
_timer_handler_entry:
    SAVE_CONTEXT

    call timer_handler

    RESTORE_CONTEXT
    mret

