OUTPUT_ARCH("riscv")

ENTRY(_start)

_stack_size = 2048;

MEMORY
{
    FLASH (rxai!w) : ORIGIN = 0x8000000, LENGTH = 128k
    RAM (wxa!ri) : ORIGIN = 0x20000000, LENGTH = 32k
}

SECTIONS
{
    .text :
    {
        *(.init)
        *(.text*)
        *(.rodata*)
    } > FLASH

    .data : AT (ADDR(.text) + SIZEOF(.text))
    {
        _data_load = LOADADDR(.data);
        _data_start = .;
        *(.data*)
        _data_end = .;
    } > RAM

    .bss :
    {
        _bss_start = .;
        *(.bss*)
        *(COMMON)
        _bss_end = .;
    } > RAM

    .stack (ORIGIN(RAM) + LENGTH(RAM) - _stack_size) :
    {
        . = _stack_size;
        _stack_top = .;
    } > RAM
}

