import binascii

app_file = "app.bin"


# def calculate_cs(data):
#     crc = binascii.crc32(data) & 0xffffffff
#     print(hex(crc))
#     return crc.to_bytes(4, byteorder="little")

def calculate_cs(data):
    poly = 0x04C11DB7
    crc = 0xFFFFFFFF

    # Process data as 32-bit little-endian words
    for i in range(0, len(data), 4):
        # pad if not multiple of 4
        chunk = data[i:i+4].ljust(4, b'\x00')
        # interpret as little-endian 32-bit word
        word = int.from_bytes(chunk, byteorder="little")

        # feed bits MSB first
        crc ^= word
        for _ in range(32):
            if crc & 0x80000000:
                crc = ((crc << 1) ^ poly) & 0xFFFFFFFF
            else:
                crc = (crc << 1) & 0xFFFFFFFF
    print(hex(crc))
    return crc.to_bytes(4, byteorder="little")


def app_fill():
    with open(app_file, "rb+") as f:
        data = f.read()
        data = data[:8192].ljust(8192, b'\x00')
        f.seek(0)
        f.write(data)
        f.truncate()
        cs = calculate_cs(data[:-4])
        f.seek(-4, 2)
        f.write(cs)


def main():
    app_fill()


if __name__ == "__main__":
    main()

