#ifndef __SPI_FLASH_H
#define __SPI_FLASH_H

#include "main.h"
#include "spi.h"
#include "gpio.h"

#define SPI_FLASH_DUMMY_BYTE 0xa5

#define SPI_FLASH_PAGE_SIZE 256

// spi flash instructions
#define SPI_FLASH_READ_JEDEC_ID 0x9f
#define SPI_FLASH_SECTOR_ERASE 0x20
#define SPI_FLASH_BLOCK_ERASE_32 0x52
#define SPI_FLASH_BLOCK_ERASE_64 0xd8
#define SPI_FLASH_CHIP_ERASE 0xc7
#define SPI_FLASH_WRITE_ENABLE 0x06
#define SPI_FLASH_READ_STATUS_REG1 0x05
#define SPI_FLASH_READ_STATUS_REG2 0x35
#define SPI_FLASH_PAGE_PROG 0x02
#define SPI_FLASH_READ_DATA 0x03

// status registers bits
#define SPI_FLASH_STATUS_BUSY 0x01  // write/erase in progress

typedef enum{
    erase_mode_chip = 0,
    erase_mode_sector,
    erase_mode_block_32kb,
    erase_mode_block_64kb
} erase_mode_t;

extern void spi_flash_init();
extern uint32_t spi_flash_read_id();
extern void spi_flash_erase_sector(uint32_t sector_addr);
extern void spi_flash_erase_block_32kb(uint32_t block_addr);
extern void spi_flash_erase_block_64kb(uint32_t block_addr);
extern void spi_flash_erase_chip();
extern void spi_flash_write_buffer(uint8_t *pbuf, uint32_t addr, uint32_t len);
extern void spi_flash_read_buffer(uint8_t *pbuf, uint32_t addr, uint32_t len);

#endif
