/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2025 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "crc.h"
#include "usart.h"
#include "gpio.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include <stdio.h>
#include "spi_flash.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */
typedef void (*app_entry_t)(void);
/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
#define APP_FLASH_OFFSET 0x00000000U
#define APP_MAX_SIZE     (8 * 1024U)
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/

/* USER CODE BEGIN PV */
__attribute__((section(".app_buf"))) uint8_t app_buf[APP_MAX_SIZE];
__attribute__((aligned(4))) uint8_t app_burn_buf[APP_MAX_SIZE];
/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
uint8_t receive_burn_request()
{
    uint8_t buf[8] = {0};
    if(HAL_UARTEx_ReceiveToIdle(&huart1, buf, sizeof(buf), NULL, 5000) == HAL_OK){
        if(buf[0] == 'b' &&
           buf[1] == 'u' &&
           buf[2] == 'r' &&
           buf[3] == 'n'){
            return 1;
        }
    }
    return 0;
}

uint8_t valify_app_data(uint8_t *buf)
{
    uint32_t cs = HAL_CRC_Calculate(&hcrc, (uint32_t *)buf, (APP_MAX_SIZE - 4) / 4);
    if(cs == *(uint32_t *)(buf + APP_MAX_SIZE - 4)){
        return 1;
    }
    return 0;
}

uint8_t receive_burn_data()
{
    if(HAL_UARTEx_ReceiveToIdle(&huart1, app_burn_buf, APP_MAX_SIZE, NULL, 2000)
       == HAL_OK){
        if(valify_app_data(app_burn_buf)){
            return 1;
        }
    }
    return 0;
}

uint8_t burn_data()
{
    // spi_flash_erase_block_32kb(0);
    spi_flash_erase_sector(0);
    spi_flash_erase_sector(4096);
    spi_flash_write_buffer(app_burn_buf, APP_FLASH_OFFSET, APP_MAX_SIZE);
    spi_flash_read_buffer(app_buf, APP_FLASH_OFFSET, APP_MAX_SIZE);
    return valify_app_data(app_buf);
}

void send_burn_ack(uint8_t ack)
{
    HAL_Delay(500);
    if(ack){
        printf("ack\r\n");
    } else{
        printf("nack\r\n");
    }
}

void jump_to_app(uint32_t app_addr)
{
    // Read MSP and ResetHandler from vector table
    uint32_t app_stack = *(uint32_t *)app_addr;
    uint32_t app_reset = *(uint32_t *)(app_addr + 4U);
    app_entry_t app_entry = (app_entry_t)app_reset;

    // Deinit peripherals that might interfere
    __disable_irq();
    SysTick->CTRL = 0;
    HAL_DeInit();

    // Set vector table offset to RAM
    SCB->VTOR = app_addr;

    // Set main stack pointer
    __set_MSP(app_stack);
    __set_PSP(app_stack);

    __enable_irq();
    app_entry();
}
/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{

  /* USER CODE BEGIN 1 */

  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  HAL_Init();

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_USART1_UART_Init();
  MX_CRC_Init();
  /* USER CODE BEGIN 2 */

  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
  spi_flash_init();
  GPIO_PinState key_state = HAL_GPIO_ReadPin(key0_GPIO_Port, key0_Pin);
  if(key_state == GPIO_PIN_RESET){
      HAL_Delay(10);
      key_state = HAL_GPIO_ReadPin(key0_GPIO_Port, key0_Pin);
  }
  if(key_state == GPIO_PIN_RESET){
      while(!receive_burn_request());
      send_burn_ack(1);
      do{
          if(receive_burn_data()){
              send_burn_ack(1);
              break;
          } else{
              send_burn_ack(0);
          }
      } while(1);
      if(!burn_data()){
          while(1){
              HAL_GPIO_TogglePin(led1_GPIO_Port, led1_Pin);
              HAL_Delay(100);
          }
      }
  } else{
      spi_flash_read_buffer(app_buf, APP_FLASH_OFFSET, APP_MAX_SIZE);
      if(valify_app_data(app_buf))
          jump_to_app((uint32_t)app_buf);
  }
  while (1)
  {
      HAL_GPIO_TogglePin(led0_GPIO_Port, led0_Pin);
      HAL_Delay(100);
    /* USER CODE END WHILE */

    /* USER CODE BEGIN 3 */
  }
  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSE;
  RCC_OscInitStruct.HSEState = RCC_HSE_ON;
  RCC_OscInitStruct.HSEPredivValue = RCC_HSE_PREDIV_DIV1;
  RCC_OscInitStruct.HSIState = RCC_HSI_ON;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSE;
  RCC_OscInitStruct.PLL.PLLMUL = RCC_PLL_MUL9;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }

  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV2;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_2) != HAL_OK)
  {
    Error_Handler();
  }
}

/* USER CODE BEGIN 4 */

/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  __disable_irq();
  while (1)
  {
  }
  /* USER CODE END Error_Handler_Debug */
}
#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */
