import signal
import serial
from time import sleep

serial_dev = "/dev/ttyUSB0"
app_file = "app.bin"
burn_req = b"burn\n"
ack = b"ack"
nack = b"nack"

ser = serial.Serial(port=serial_dev, baudrate=115200,
        bytesize=8, stopbits=1, timeout=2)

def signal_handler(signum, frame):
    ser.close()
    print("Exit")
    exit(1)


def send_burn_req():
    ser.write(burn_req)
    ser.flush()


def receive_burn_ack():
    ack = ser.readline()
    return ack


def send_burn_data(data):
    ser.write(data)
    ser.flush()


def main():
    signal.signal(signal.SIGINT, signal_handler)
    with open(app_file, "rb") as f:
        app_data = f.read()
    while True:
        print("sending burning request...")
        send_burn_req()
        print("waiting for ack...")
        ack = receive_burn_ack()
        if ack.startswith(b"ack") or ack.startswith(b"nack"):
            print("ack received.")
            break;
    while True:
        sleep(0.5)
        print("sending app data...")
        # b = b"0123456789abcdef\n"
        # send_burn_data(b)
        send_burn_data(app_data)
        print("waiting for ack...")
        ack = receive_burn_ack()
        print(ack)
        if ack.startswith(b"ack"):
            print("ack received.")
            break;

if __name__ == "__main__":
    main()

