#ifndef _FTL_H_
#define _FTL_H_

#include <stdint.h>
#include <assert.h>

#define FLASH_CAP (16 * 1024 * 1024)
#define SECTOR_SIZE 512
#define BLOCK_SIZE (64 * 1024)
#define SEC_PER_BLK (BLOCK_SIZE / SECTOR_SIZE)
#define BLOCK_COUNT (FLASH_CAP / BLOCK_SIZE)
#define INDEX_BLK_NUM 4
#define DATA_BLK_NUM (BLOCK_COUNT - INDEX_BLK_NUM)
#define RES_INDEX_BLK 1
#define RES_DATA_BLK 1
#define INDEX_BLK_RES_SEC 1
#define DATA_BLK_HEADER_SEC 1
#define DATA_BLK_TAIL_SEC 1
#define L2P_ITEM_SIZE 4
#define L2P_ITEMS_PER_SEC (SECTOR_SIZE / L2P_ITEM_SIZE)
#define MAX_L2P_PER_INDEX_BLK ((SEC_PER_BLK - INDEX_BLK_RES_SEC) * SECTOR_SIZE / L2P_ITEM_SIZE)

#define SEC_TO_ADDR(n) (SECTOR_SIZE * (n))
#define BLK_TO_ADDR(n) (BLOCK_SIZE * (n))
#define BLK_TO_SEC(n) (SEC_PER_BLK * (n))
#define SEC_TO_BLK(n) ((n) / SEC_PER_BLK)

#define READ_BUF_SIZE SECTOR_SIZE
#define WRITE_BUF_SIZE SECTOR_SIZE
#define L2P_BUF_SIZE SECTOR_SIZE

#define DATA_BLK_MASK_FULL 0xf
#define DATA_BLK_MASK_FREE 0x0
#define DATA_BLK_MASK_USED 0x1
#define DATA_BLK_MASK_TODO 0x2

#define ALL_VALID 0x0
#define PARTIAL_VALID 0x1
#define ALL_GARBAGE 0xf

#define FTL_DEBUG 1

#if FTL_DEBUG
#define FTL_ASSERT(v) //assert(v)
#else
#define FTL_ASSERT(v)
#endif

struct ftl_manager{
    uint16_t data_sec_off;
    uint16_t data_blk_off;
    uint16_t index_sec_off;
    uint16_t index_item_off;
    uint16_t free_data_blk_num;
};

typedef struct{
    uint16_t lsec;
    uint16_t psec;
} __attribute__((aligned(4))) l2p_item_t;


void ftl_init();
uint32_t get_capacity();
uint8_t read_lsec_seq(uint8_t *buf, uint16_t lsec, uint16_t sec_num);
uint8_t write_lsec_seq(uint8_t *buf, uint16_t lsec, uint16_t sec_num);

#endif
